require( "scripts/style.lua" )

kStartX = 125;
kRow1Y = 135;
kRow2Y = 400;
kHorizontalSpacing = 300;
kVerticalSpacing = 180;
kTextYOffset = 115;
kTextWidth = 250;
kHeaderPaddingX = 10;
kHeaderPaddingY = 4;
kHeaderVerticalSpacing = 40

MakeDialog
{
	Bitmap
	{ 
		image="backgrounds/helppage",	
		x=kCenter,
		y=kCenter,

		-- Title
		Text
		{
			font = HelpTableInfoFont,
			name = "help",
			x=0,y=8,w=kMax ,h=kMax,
			flags = kHAlignCenter+ kVAlignTop,
			label = "ui.dialog.help.title"
		};
		
		-- Previous button
		Button{
			x = kCenter - 70,
			y = 497,
			--flags = + ,
			font = StandardButtonFont,
			graphics = HelpLeftButtonGraphics,
			name="previous",
			type = kPush,
			rolloversound = "assets/audio/sfx/dialog_roll.ogg",
			sound = "assets/audio/sfx/dialog_click.ogg",
			command=
				function()
					PopModal();
					DoModal("scripts/helpmenu1.lua");
				end
		};
		
		-- "Page X of X" text
		Text
		{			
			x=kCenter,
			y=457,
			w=kMax ,h=kMax,
			flags = kHAlignCenter+ kVAlignCenter,
			font = { standardFont, 20, BlackColor };
			name = "help",
			label = "help_paginate_2",
		};

		-- Next button
		Button{
			x = kCenter + 70,
			y = 497,
			font = StandardButtonFont,
			graphics = HelpRightButtonGraphics,
			name="next",
			type = kPush,
			rolloversound = "assets/audio/sfx/dialog_roll.ogg",
			sound = "assets/audio/sfx/dialog_click.ogg",
			command=
				function()
					PopModal();
					DoModal("scripts/helpmenu3.lua");
				end
		};
			
		-- Close button
		Button{
			--flags = kHAlignCenter+ kVAlignBottom,
			x = kCenter+250,
			y = 501,
			font = StandardButtonFont,
			graphics = StandardButtonGraphics,
			name="ok",
			rolloversound = "assets/audio/sfx/dialog_roll.ogg",
			sound = "assets/audio/sfx/dialog_click.ogg",
			label="close",
			type = kPush,
			close=true
		};
		
		
		
		-- Server Header
		Bitmap
		{ 
			image="images/helpscreen/headerbg",	
			x=kStartX - 15,
			y=kRow1Y-kHeaderVerticalSpacing,
		};
		Text
		{			
			x=kStartX+kHeaderPaddingX - 15,
			y=kRow1Y-kHeaderVerticalSpacing+kHeaderPaddingY,
			w=kMax ,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			font = HelpHeaderFont;
			name = "help",
			label = "help_header_serving",
		};
		
		-- "Take Gifts"
		Bitmap
		{ 
			image="images/helpscreen/help_2_image01",	
			x=kStartX + (kHorizontalSpacing*0) - 15,
			y=kRow1Y + 70,
		};
		Text
		{			
			x=kStartX + (kHorizontalSpacing*0) - 15,
			y=kRow1Y + kTextYOffset - 110,
			w=175 ,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			font = HelpFont;
			name = "help",
			label = "help_serving_text_1",
		};
		
		
		-- "Serve Food"
		Bitmap
		{ 
			image="images/helpscreen/help_2_image02",	
			x=kStartX + (kHorizontalSpacing*1) - 95,
			y=kRow1Y + 85,
		};
		Text
		{			
			x=kStartX + (kHorizontalSpacing*1) - 110,
			y=kRow1Y + kTextYOffset - 110,
			w=170 ,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			font = HelpFont;
			name = "help",
			label = "help_serving_text_2",
		};
		
		-- "Complete Special..."
		Bitmap
		{ 
			image="images/helpscreen/help_2_image03",	
			x=635,
			y=kRow1Y + kTextYOffset - 90,
		};
		Text
		{			
			x=520 - 15,
			y=kRow1Y + kTextYOffset - 110,
			w=130 ,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			font = HelpFont;
			name = "help",
			label = "help_serving_text_3",
		};
		
		
		Text
		{			
			x=520 - 15,
			y=kVerticalSpacing+kRow1Y + kTextYOffset - 175 + 30,
			w=120 ,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			font = HelpFont;
			name = "help",
			label = "help_serving_text_4",
		};
		
		
		Text
		{			
			x=0,
			y=450,
			w=kMax ,h=kMax,
			flags = kHAlignCenter + kVAlignTop,
			font = { nonItalicFont, 17, BlackColor };
			name = "help",
			label = "help_serving_text_5",
		};
		
	}
}



